#include "paintgraphicsview.h"

PaintGraphicsView::PaintGraphicsView(QWidget * parent):QGraphicsView(parent)
{
    currentAction = Point;
    mousePressed = false;
    curLine = NULL;
    scene = new QGraphicsScene(this);
    this->setScene(scene);
    scene->setSceneRect(0, 0, 400, 400);
    pen = new QPen();
    pen->setWidth(2);
}

void PaintGraphicsView::mousePressEvent(QMouseEvent * event)
{
    mousePressed = true;
    int x = event->x() - 50;
    int y = event->y() - 50;
    lastMouseX = x;
    lastMouseY = y;
    if (currentAction == Point) {
        scene->addLine(x, y, x, y, *pen);
    }
    if (currentAction == Line) {
        curLine = scene->addLine(x, y, x, y, *pen);
    }
}
void PaintGraphicsView::mouseReleaseEvent(QMouseEvent * event)
{
    mousePressed = false;
    int x = event->x() - 50;
    int y = event->y() - 50;
    if (currentAction == Point) {
    }
    if (currentAction == Line) {
        curLine = NULL;
    }
}

void PaintGraphicsView::mouseMoveEvent(QMouseEvent * event)
{
    int x = event->x() - 50;
    int y = event->y() - 50;
    if (!mousePressed)
        return;
    if (currentAction == Point) {
        scene->addLine(lastMouseX, lastMouseY, x, y, *pen);
    }
    if (currentAction == Line) {
        curLine->setLine(curLine->line().x1(), curLine->line().y1(), x, y);
    }
    lastMouseX = x;
    lastMouseY = y;
}

void PaintGraphicsView::clearView()
{
    scene->clear();
}
