#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "main.h"
#include "actionradiobutton.h"
#include "paintgraphicsview.h"
namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    PaintGraphicsView* paintView;
    QButtonGroup* actionButtonGroup;
    QSlider* slider;

    ~MainWindow();

    const static int WINDOW_X0 = 100;
    const static int WINDOW_Y0 = 100;
    const static int WINDOW_W = 600;
    const static int WINDOW_H = 500;
    const static int PAINT_X0 = 0;
    const static int PAINT_Y0 = 0;
    const static int PAINT_W = 500;
    const static int PAINT_H = 500;
    const static int BUTTON_GROUP_X0 = PAINT_X0 + PAINT_W;
    const static int BUTTON_GROUP_Y0 = PAINT_Y0;
    const static int BUTTON_GROUP_W = 100;
    const static int BUTTON_GROUP_H = 200;

private slots:
    void actionTypeChange();
    void clearView();
    void widthChanged();
    void on_centralWidget_destroyed();

private:
    Ui::MainWindow *ui;
};

#endif // MAINWINDOW_H
