#include "mainwindow.h"
#include "ui_mainwindow.h"



MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    this->setGeometry(WINDOW_X0, WINDOW_Y0, WINDOW_W, WINDOW_H);
    paintView = new PaintGraphicsView(this);
    paintView->setGeometry(PAINT_X0, PAINT_Y0, PAINT_W, PAINT_H);
    actionButtonGroup = new QButtonGroup(this);
    ActionRadioButton* pointButton = new ActionRadioButton(this, Point);
    pointButton->setGeometry(PAINT_X0+PAINT_W + 10, PAINT_Y0 + 10, 100, 20);
    pointButton->setText("point");
    ActionRadioButton* lineButton = new ActionRadioButton(this, Line);
    lineButton->setGeometry(PAINT_X0+PAINT_W + 10, PAINT_Y0 + 30, 100, 20);
    lineButton->setText("line");
    connect(actionButtonGroup, SIGNAL(buttonClicked(int)), this, SLOT(actionTypeChange()));
    actionButtonGroup->addButton(pointButton);
    actionButtonGroup->addButton(lineButton);
    pointButton->click();

    QPushButton * clearButton = new QPushButton(this);
    clearButton->setGeometry(PAINT_X0+PAINT_W + 10, PAINT_H - 30, 100 - 20, 20);
    clearButton->setText("Clear");
    clearButton->setCheckable(false);
    connect(clearButton, SIGNAL(pressed()), this, SLOT(clearView()));

    slider = new QSlider(Qt::Horizontal, this);
    slider->setGeometry(PAINT_X0+PAINT_W + 10, PAINT_Y0 + 50, 100 - 20, 20);
    slider->setMinimum(2);
    slider->setMaximum(20);
    connect(slider, SIGNAL(valueChanged(int)), this, SLOT(widthChanged()));
}

void MainWindow::actionTypeChange() {
    ActionRadioButton* w = (ActionRadioButton*)actionButtonGroup->checkedButton();
    this->paintView->currentAction = w->actionType;
}
void MainWindow::clearView() {
    this->paintView->clearView();
}
void MainWindow::widthChanged() {
    this->paintView->pen->setWidth(slider->value());
}

MainWindow::~MainWindow()
{
    delete ui;
}
