#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QImage>
#include <QLabel>
#include <QtGui>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    void resizeEvent(QResizeEvent * event);
    void moveEvent(QMoveEvent * event);

private slots:
    void addNewTab(void);
    void deleteTab(int index);
    void sizeChainClick(void);
    void fullscreenClick(void);
    void saveClick(void);
    void helpClick(void);
    void resizeAll(void);
    void xcentreChanged(double d);
    void ycentreChanged(double d);
    void xsizeChanged(double d);
    void ysizeChanged(double d);
    void buildClick(void);

private:
    Ui::MainWindow *ui;
};

#endif // MAINWINDOW_H
