#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "rcolorpicker.h"
#include "PL.h"
#include "bytearrayclass.h"
#include "bytearrayprototype.h"
#include <cstring>
#include <vector>
#include <QtScript>
#include <iostream>
#include <QTime>

#define FOR(a, b) for(int a = 0; a < (b); a++)
#define LD long double

const int MAX_TABS = 20;
const int num_seeking = 5;
const double INF = 1000000000.0;
const double INF0 = 1e-7;
const int numDecimals = 8;
const double EPS = 1e-8;
const double zoomCoef = 0.5;
const double moveCoef = 0.2;
const double wheelZoomCoef = 2.0;

class View : public QGraphicsView
{
    //Q_OBJECT
public:
    View(QWidget *parent = 0);
protected:
    void mousePressEvent ( QMouseEvent * event );
    void mouseReleaseEvent ( QMouseEvent * event );
    void mouseMoveEvent ( QMouseEvent * event );
    void wheelEvent( QWheelEvent * event);
};

View::View(QWidget *parent)
    : QGraphicsView(parent)
{
}

class SpeedSlider : public QSlider
{
public:
    SpeedSlider(QWidget *parent = 0);
protected:
    void mouseReleaseEvent ( QMouseEvent * event );
};

SpeedSlider::SpeedSlider(QWidget *parent)
    : QSlider(parent)
{
}

class TabTextEdit : public QPlainTextEdit
{
public:
    TabTextEdit(QWidget *parent = 0);
protected:
    void keyPressEvent ( QKeyEvent * e );
};

TabTextEdit::TabTextEdit(QWidget *parent)
    : QPlainTextEdit(parent)
{
}


class CTabWidget : public QTabWidget
{
public:
        CTabWidget(QWidget *parent =0);
        //virtual ~CTabWidget();

        QTabBar* tabBar() const { return (QTabWidget::tabBar());}
};

CTabWidget::CTabWidget(QWidget *parent)
    : QTabWidget(parent)
{
}


struct tabContent{
    QWidget * t;
    TabTextEdit * e;
    QToolButton * buildButton, *visButton;
    RColorPicker * colorPicker;
};

tabContent tabs[MAX_TABS];

QGraphicsScene* scene;
View* view;
QImage curImage;
QWidget *topWidget, *bottomWidget, *mainWidget;
CTabWidget *tabWidget;
QToolButton * plusTab, *sizeChainButton, *fullscreenButton, *saveButton, *helpButton;
QDoubleSpinBox *xcBox, *ycBox, *xsBox, *ysBox;
QLabel *centerCaption, *centerCommaCaption, *sizeCaption;
QString scriptContents;
SpeedSlider * speedSlider;
//int windowWidth, windowHeight, windowX, windowY;
bool sizeChained, fullscreen, autoAdjustBoxes;
QFont defFont;
int num_tabs;
double chainRatio;
int num_parts = 100;
int bd = 1;
QImage getGraph(int width, int height)
{
    num_parts = speedSlider->value();
    QScriptEngine engine;
    ByteArrayClass * baClass;
    baClass = new ByteArrayClass(&engine);
    engine.globalObject().setProperty("ByteArray", baClass->constructor());
    QScriptValue baScriptVal = baClass->newInstance(6 * width);
    engine.globalObject().setProperty("ba", baScriptVal);

    QSize imgSize(width, height);
    QImage image(imgSize, QImage::Format_RGB32);
    image.fill(qRgb(255, 255, 255));


    LD X0, Y0;
    LD XS, YS;
    XS = xsBox->value();
    YS = ysBox->value();
    X0 = xcBox->value() - XS / 2;
    Y0 = ycBox->value() - YS / 2;

    LD px = XS / imgSize.width();
    LD ps = px / num_parts;
    LD py = YS / imgSize.height();

    int bwAxises = 50;
    double distA = bwAxises * px;
    double firstA = distA * trunc(X0 / distA);
    if (X0 > -EPS) firstA += distA;
    int firstAp = trunc((firstA - X0) / px);
    for (int i = firstAp; i < width; i += bwAxises, firstA += distA)
        FOR(j, height)
        {
                image.setPixel(i, j, qRgb(0, 0, 0));
                if (distA - fabs(firstA) > EPS)
                {
                    image.setPixel(i - 1, j, qRgb(0, 0, 0));
                    image.setPixel(i + 1, j, qRgb(0, 0, 0));
                }
        }
    distA = bwAxises * py;
    firstA = distA * trunc(Y0 / distA);
    if (Y0 > -EPS) firstA += distA;
    firstAp = trunc((firstA - Y0) / py);
    for (int j = firstAp; j < height; j += bwAxises, firstA += distA)
        FOR(i, width)
        {
            image.setPixel(i, j, qRgb(0, 0, 0));
            if (distA - fabs(firstA) > EPS)
            {
                image.setPixel(i, j - 1, qRgb(0, 0, 0));
                image.setPixel(i, j + 1, qRgb(0, 0, 0));
            }
        }


    std::vector<int> tabsOrder;
    tabsOrder.clear();
    for (int i = 0; i < num_tabs; ++i)
        if (i != tabWidget->currentIndex() && !tabs[i].visButton->isChecked()) tabsOrder.push_back(i);
    if (!tabs[tabWidget->currentIndex()].visButton->isChecked())tabsOrder.push_back(tabWidget->currentIndex());

    FOR(t, tabsOrder.size())
    {
        int c = tabsOrder[t];
        tabWidget->tabBar()->setTabTextColor(tabsOrder[t], QColor(0, 0, 0));


        QString expr = tabs[c].e->toPlainText();
        QString tabName = tabs[c].e->toPlainText();
        for (int i = tabName.length(); i < 7; ++i)
            tabName.push_back(' ');

        tabName.resize(7);
        if (expr == "") tabName = "New Tab";
        tabWidget->tabBar()->setTabText(tabsOrder[t], tabName);
        QString expr1 = "";
        bool wordBegin = false;
        FOR(i, expr.length())
        {
            if (expr[i] >= 'a' && expr[i] <= 'z' && expr[i] !='x')
            {
                if (!wordBegin) expr1 += "Math.";
                expr1 += expr[i];
                wordBegin = true;
            }
            else {expr1 += expr[i];wordBegin = false;}
        }
        if (expr1 == "") {continue;}

        QString contents = scriptContents;
        QString contents1 = "";
        char ws[20];
        memset(ws, 0, sizeof(ws));
        sprintf(ws, "%lf", (double)X0);
        contents1 += "X0 = ";
        contents1 += ws;
        contents1 += ";\n";
        memset(ws, 0, sizeof(ws));
        sprintf(ws, "%lf", (double)px);
        contents1 += "px = ";
        contents1 += ws;
        contents1 += ";\n";
        memset(ws, 0, sizeof(ws));
        sprintf(ws, "%d", num_parts);
        contents1 += "num_parts = ";
        contents1 += ws;
        contents1 += ";\n";
        memset(ws, 0, sizeof(ws));
        sprintf(ws, "%lf", (double)ps);
        contents1 += "ps = ";
        contents1 += ws;
        contents1 += ";\n";
        memset(ws, 0, sizeof(ws));
        sprintf(ws, "%lf", (double)Y0);
        contents1 += "Y0 = ";
        contents1 += ws;
        contents1 += ";\n";
        memset(ws, 0, sizeof(ws));
        sprintf(ws, "%lf", (double)py);
        contents1 += "py = ";
        contents1 += ws;
        contents1 += ";\n";
        memset(ws, 0, sizeof(ws));
        sprintf(ws, "%d", num_seeking);
        contents1 += "num_seeking = ";
        contents1 += ws;
        contents1 += ";\n";
        memset(ws, 0, sizeof(ws));
        sprintf(ws, "%d", imgSize.height());
        contents1 += "_height = ";
        contents1 += ws;
        contents1 += ";\n";
        memset(ws, 0, sizeof(ws));
        sprintf(ws, "%d", imgSize.width());
        contents1 += "_width = ";
        contents1 += ws;
        contents1 += ";\n";
        FOR(i, contents.length())
            if (contents[i] == '#') contents1 += expr1;
                else contents1 += contents[i];
        //std::cout << contents1.toStdString() << '\n';
        //QTime time;
        //time.start();
        QScriptValue result = engine.evaluate(contents1);
        //std::cout << time.elapsed();
        if (result.isError()) {tabWidget->tabBar()->setTabTextColor(tabsOrder[t], QColor(255, 0, 0));continue;}
        QByteArray ba;
        baClass->fromScriptValue(baScriptVal, ba);
        //std::cout << "\n" << ba.length();
        //return image;
        int j = 0;
        FOR(i, imgSize.width())
        {
            while (ba[j] != 255 || ba[j + 1] != 255)
            {
                int mn = ba[j] * 256 + ba[j + 1];
                int mx = ba[j + 2] * 256 + ba[j + 3];
                j += 4;
                for (int g = mn; g <= mx; ++g)
                    image.setPixel(i, g, (tabs[c].colorPicker->color()).rgb());
            }
            j += 2;
        }


    }

    delete baClass;
    return image.mirrored();


/*

    std::vector<int> tabsOrder;
    tabsOrder.clear();

    for (int i = 0; i < num_tabs; ++i)
        if (i != tabWidget->currentIndex() && !tabs[i].visButton->isChecked()) tabsOrder.push_back(i);
    if (!tabs[tabWidget->currentIndex()].visButton->isChecked())tabsOrder.push_back(tabWidget->currentIndex());

    //freopen("errors.log", "a", stdout);
    //FOR(i, tabsOrder.size())
    //       printf("%d ", (tabs[tabsOrder[i]].colorPicker->color()).value());
    FOR(t, tabsOrder.size())
    {
        int c = tabsOrder[t];
        LD ps = px / num_parts;
        FOR(i, imgSize.width())
        {
            LD x = X0 + px * i;
            int mn = 1000000;
            int mx = -1000000;

            for (int j = -1; j < num_parts; ++j)
            {
                if(j != -1) x += ps / 2;
                LD y = getY(c, x);
                int w = int(round((wy - Y0) / py));
                if (wy != NaN && w >= -(num_seeking - 1) * imgSize.height() && w < num_seeking * imgSize.height())
                {
                    mn = std::min(mn, w);
                    mx = std::max(mx, w);
                }
                else
                {
                    if (mx != -1000000)
                        for (int j = std::max(mn, 0); j <= std::min(mx, imgSize.height() - 1); ++j)
                            image.setPixel(i, j, (qRgb(255, 0, 0)));
                    mn = 1000000;
                    mx = -1000000;
                }
                wx += ps;
            }
            if (mx != -1000000)
                for (int j = mn; j < mx + 1; ++j)
                    image.setPixel(i, j, (tabs[c].colorPicker->color()).rgb());
        }
        //printf("%d ", (tabs[c].colorPicker->color()).value());


    }
    //image.setPixel(view->width() - 3, view->height() - 3, qRgb(255, 0, 0));
    return image.mirrored();
    */
}

inline int intChars(double x)
{
    int w = abs(trunc(x));
    int st = 10;
    int i = 1;
    while (st <= w) st *= 10, i++;
    return i;
}

void setBoxes()
{
    double sz = xsBox->value();
    xsBox->setSingleStep(sz * zoomCoef);
    ysBox->setSingleStep(sz * zoomCoef);
    xcBox->setSingleStep(sz * moveCoef);
    ycBox->setSingleStep(ysBox->value() * moveCoef);
    xcBox->setDecimals(numDecimals - intChars(xcBox->value()));
    ycBox->setDecimals(numDecimals - intChars(ycBox->value()));
    xsBox->setDecimals(numDecimals - intChars(xsBox->value()));
    ysBox->setDecimals(numDecimals - intChars(ysBox->value()));
}

void refreshGraph()
{

    QSize imgSize1(mainWidget->width() - 2 * bd, mainWidget->height() - 2 * bd);
    QImage image1(imgSize1, QImage::Format_RGB32);
    //image1.fill(qRgb(255, 0, 0));
    //getImage
    image1 = getGraph(imgSize1.width(), imgSize1.height());
    curImage = image1;
    //if (pixmap != NULL) scene->removeItem(pixmap);
    if (scene != NULL) delete scene;
    scene = new QGraphicsScene();//ui->centralWidget->geometry());
    scene->addPixmap(QPixmap::fromImage(image1));
    view->setScene(scene);
}

void MainWindow::resizeAll()
{
    //if (!fullscreen) windowWidth = this->width(), windowHeight = this->height();
    int bwHeight = 25;
    int twHeight = 54;
    topWidget->setGeometry(0, 0, this->width(), twHeight);
    mainWidget->setGeometry(0, twHeight, this->width(), this->height() - twHeight - bwHeight);
    tabWidget->setGeometry(0, 0, this->width(), 80);
    bottomWidget->setGeometry(0, mainWidget->height() + twHeight, this->width(), bwHeight);

    int cx = 10;
    int cy = 5;
    int sy = 15;
    int wBox = 85;
    centerCaption->setGeometry(cx, cy, 120, sy);
    cx += centerCaption->width();
    xcBox->setGeometry(cx, cy - 3, wBox, 21);
    cx += xcBox->width();
    centerCommaCaption->setGeometry(cx, cy, 10, sy);
    cx += centerCommaCaption->width();
    ycBox->setGeometry(cx, cy - 3, wBox, 21);
    cx += ycBox->width();
    cx += 10;
    sizeCaption->setGeometry(cx, cy, 35, sy);
    cx += sizeCaption->width();
    xsBox->setGeometry(cx, cy - 3, wBox, 21);
    cx += xsBox->width();
    cx += 5;
    sizeChainButton->setGeometry(cx, cy - 3, 30, 21);
    cx += sizeChainButton->width();
    cx += 5;
    ysBox->setGeometry(cx, cy - 3, wBox, 21);
    cx += ysBox->width();
    cx += 10;
    speedSlider->setGeometry(cx, cy - 3, 130, 21);

    int sz = 21;
    int sp = 5;
    cx = bottomWidget->width() - 3 * sz - 3 * sp;
    cy = 2;
    fullscreenButton->setGeometry(cx, cy, sz, sz);
    cx += fullscreenButton->width() + sp;
    saveButton->setGeometry(cx, cy, sz, sz);
    cx += saveButton->width() + sp;
    helpButton->setGeometry(cx, cy, sz, sz);
    cx += helpButton->width() + sp;

    for(int i = 0; i < num_tabs; ++i)
    {
        tabs[i].t->setGeometry(0, 0, tabWidget->width(), tabWidget->height());
        cx = 0;
        cy = 0;
        tabs[i].e->setGeometry(cx, cy, tabWidget->width() - 63, 28);
        cx += tabs[i].e->width();
        tabs[i].colorPicker->setGeometry(cx - 28, cy, 28, 28);
        tabs[i].buildButton->setGeometry(cx, cy, 28, 28);
        cx += tabs[i].buildButton->width();
        tabs[i].visButton->setGeometry(cx, cy, 28, 28);
        cx += tabs[i].visButton->width();
    }
    view->setGeometry(0, 0, mainWidget->width(), mainWidget->height());
    //view->adjustSize();
    refreshGraph();
}


MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    //this->setWindowTitle("GraphBuilder");
    QString fileName("eval.js");
    QFile scriptFile(fileName);
    scriptFile.open(QIODevice::ReadOnly);
    QTextStream stream(&scriptFile);
    scriptContents = stream.readAll();

    ui->setupUi(this);
    this->setGeometry(100, 100, 800, 600);

    defFont.setPointSize(10);
    mainWidget = new QWidget(this);
    topWidget = new QWidget(this);


    tabWidget = new CTabWidget(topWidget);
    tabWidget->setUsesScrollButtons(true);
    tabWidget->setTabsClosable(true);
    QFont monoFont("Courier New");
    tabWidget->tabBar()->setFont(monoFont);
    //tabWidget->tabBar()->tabButton()setFixedWidth(85);
    //QTabBar tabBar(*tabWidget->tabBar());
    //tabBar.setFixedWidth(85);
    //tabWidget->setTabBar(tabBar);
    //char s[30];
    //sprintf(s, "%d", ui->centralWidget->x());
    //ui->label->setText(s);
    tabWidget->setMovable(false);
    num_tabs = 0;
    plusTab = new QToolButton(topWidget);
    plusTab->setGeometry(3, 2, 20, 20);
    //plusTab->setText("+");
    plusTab->setAutoRaise(true);
    QIcon IconNew = QIcon("icons\\plus_64.png");

    plusTab->setIcon(IconNew);
    //plusTab->setFixedSize(plusTab->iconSize());
    addNewTab();
    connect(plusTab, SIGNAL(clicked()), this, SLOT(addNewTab()));
    connect(tabWidget, SIGNAL(tabCloseRequested(int)), this, SLOT(deleteTab(int)));

    bottomWidget = new QWidget(this);
    //bottomWidget->setCursor(QCursor(Qt::CrossCursor));


    centerCaption = new QLabel(bottomWidget);
    centerCaption->setFont(defFont);
    centerCaption->setText("Center coordinates:");

    xcBox = new QDoubleSpinBox(bottomWidget);
    xcBox->setFont(defFont);
    xcBox->setMinimum(-INF);
    xcBox->setMaximum(INF);
    xcBox->setDecimals(numDecimals);

    centerCommaCaption = new QLabel(bottomWidget);
    centerCommaCaption->setFont(defFont);
    centerCommaCaption->setText(", ");

    ycBox = new QDoubleSpinBox(bottomWidget);
    ycBox->setFont(defFont);
    ycBox->setMinimum(-INF);
    ycBox->setMaximum(INF);
    ycBox->setDecimals(numDecimals);

    sizeCaption = new QLabel(bottomWidget);
    sizeCaption->setFont(defFont);
    sizeCaption->setText("Size:");

    xsBox = new QDoubleSpinBox(bottomWidget);
    xsBox->setFont(defFont);
    xsBox->setMinimum(INF0);
    xsBox->setMaximum(INF);
    xsBox->setDecimals(numDecimals);

    sizeChainButton = new QToolButton(bottomWidget);
    sizeChainButton->setAutoRaise(true);
    IconNew = QIcon("icons\\chain_on1.png");
    sizeChainButton->setIcon(IconNew);
    sizeChainButton->setIconSize(QSize(24, 24));
    sizeChained = true;
    connect(sizeChainButton, SIGNAL(clicked()), this, SLOT(sizeChainClick()));


    ysBox = new QDoubleSpinBox(bottomWidget);
    ysBox->setFont(defFont);
    ysBox->setMinimum(INF0);
    ysBox->setMaximum(INF);
    ysBox->setDecimals(numDecimals);

    speedSlider = new SpeedSlider(bottomWidget);
    speedSlider->setMinimum(10);
    speedSlider->setMaximum(500);
    speedSlider->setOrientation(Qt::Horizontal);
    speedSlider->setPageStep(100);
    speedSlider->setSingleStep(10);
    speedSlider->setSliderPosition(50);
    speedSlider->setTracking(true);
    speedSlider->setWhatsThis("Quality/speed");

    fullscreenButton = new QToolButton(bottomWidget);
    fullscreenButton->setAutoRaise(true);
    fullscreenButton->setCheckable(false);
    IconNew = QIcon("icons\\fullscreen.png");
    fullscreenButton->setIcon(IconNew);
    fullscreenButton->setIconSize(QSize(24, 24));
    fullscreen = false;
    connect(fullscreenButton, SIGNAL(clicked()), this, SLOT(fullscreenClick()));

    saveButton = new QToolButton(bottomWidget);
    saveButton->setAutoRaise(true);
    saveButton->setCheckable(false);
    IconNew = QIcon("icons\\save.png");
    saveButton->setIcon(IconNew);
    saveButton->setIconSize(QSize(24, 24));
    connect(saveButton, SIGNAL(clicked()), this, SLOT(saveClick()));

    helpButton = new QToolButton(bottomWidget);
    helpButton->setAutoRaise(true);
    helpButton->setCheckable(false);
    IconNew = QIcon("icons\\help.png");
    helpButton->setIcon(IconNew);
    helpButton->setIconSize(QSize(24, 24));
    connect(helpButton, SIGNAL(clicked()), this, SLOT(helpClick()));

    //QWidget * tab0 = new QWidget(tabWidget);
    //tab0->setGeometry(0, 0, 300, 50);
    //tabWidget->addTab(tab0, tr("tab0"));
    //tabWidget->

    scene = NULL;
    view = new View(mainWidget);
    view->setCursor(QCursor(Qt::OpenHandCursor));
    view->setMouseTracking(false);
    resizeAll();

    double sz = 10.0;
    autoAdjustBoxes = true;
    xcBox->setValue(0.0);
    ycBox->setValue(0.0);
    xsBox->setValue(sz);
    ysBox->setValue(sz / curImage.width() * curImage.height());
    autoAdjustBoxes = false;
    chainRatio = xsBox->value() / ysBox->value();//((double)view->width()) / ((double)view->height());
    setBoxes();
    connect(xcBox, SIGNAL(valueChanged(double)), this, SLOT(xcentreChanged(double)));
    connect(ycBox, SIGNAL(valueChanged(double)), this, SLOT(ycentreChanged(double)));
    connect(xsBox, SIGNAL(valueChanged(double)), this, SLOT(xsizeChanged(double)));
    connect(ysBox, SIGNAL(valueChanged(double)), this, SLOT(ysizeChanged(double)));
    refreshGraph();
}

void MainWindow::xcentreChanged(double d)
{
    xcBox->setValue(d);
    setBoxes();
    if (!autoAdjustBoxes) refreshGraph();
}

void MainWindow::ycentreChanged(double d)
{
    ycBox->setValue(d);
    setBoxes();
    if (!autoAdjustBoxes)refreshGraph();
}

void MainWindow::xsizeChanged(double d)
{
    //xsBox->setValue(d);
    if (sizeChained) ysBox->setValue(d / chainRatio);
        else chainRatio = d / ysBox->value();
    setBoxes();
    if (!autoAdjustBoxes) refreshGraph();
}

void MainWindow::ysizeChanged(double d)
{
    //ysBox->setValue(d);
    if (sizeChained) xsBox->setValue(d * chainRatio);
        else chainRatio = xsBox->value() / d;
    setBoxes();
    if (!autoAdjustBoxes) refreshGraph();
}

void MainWindow::resizeEvent(QResizeEvent * event)
{
    resizeAll();
}

void MainWindow::moveEvent(QMoveEvent * event)
{
}



void MainWindow::sizeChainClick()
{
    sizeChained = !sizeChained;
    if (sizeChained)
    {
        QIcon IconNew = QIcon("icons\\chain_on1.png");
        sizeChainButton->setIcon(IconNew);
        sizeChainButton->setIconSize(QSize(24, 24));
    }
    else
    {
        QIcon IconNew = QIcon("icons\\chain_off1.png");
        sizeChainButton->setIcon(IconNew);
        sizeChainButton->setIconSize(QSize(24, 24));
    }
}

void MainWindow::fullscreenClick()
{
    fullscreen = !fullscreen;
    if (fullscreen)
    {
        QIcon IconNew = QIcon("icons\\fullscreen_exit.png");
        fullscreenButton->setIcon(IconNew);
        fullscreenButton->setIconSize(QSize(24, 24));
        //this->setGeometry(0, 0, 1920, 1080);
        this->showFullScreen();
    }
    else
    {
        QIcon IconNew = QIcon("icons\\fullscreen.png");
        fullscreenButton->setIcon(IconNew);
        fullscreenButton->setIconSize(QSize(24, 24));
        //this->setGeometry(windowX, windowY, windowWidth, windowHeight);
        this->showNormal();
    }
}

void MainWindow::saveClick()
{
    QString fileName = QFileDialog::getSaveFileName(this, tr("Save File"),
                                "untitled.png",
                                tr("Images (*.png *.jpg *.jpeg *.bmp *.xpm *.xbm)"));
    curImage.save(fileName);

}

void MainWindow::helpClick()
{

}

void MainWindow::addNewTab()

{
    if (num_tabs >= MAX_TABS) return;
    QWidget * newTab = new QWidget(tabWidget);//&tabs[num_tabs++];
    newTab->setGeometry(0, 0, tabWidget->width(), tabWidget->height());

    tabs[num_tabs].t = newTab;
    tabWidget->addTab(newTab, "New Tab");
    tabWidget->setCurrentIndex(num_tabs);
    int cx = 0;
    int cy = 0;

    TabTextEdit * tabText = new TabTextEdit(newTab);
    tabs[num_tabs].e = tabText;
    tabText->setGeometry(cx, cy, tabWidget->width() - 63, 28);
    tabText->setFocusPolicy(Qt::StrongFocus);
    tabText->setFocus();
    cx += tabText->width();
    tabText->setVisible(true);
    tabText->setFont(defFont);
    QRect w = plusTab->geometry();
    plusTab->setGeometry(w.x() + 93, w.y(), w.width(), w.height());
    //cx += 10;
    RColorPicker * colorPicker = new RColorPicker(newTab);
    tabs[num_tabs].colorPicker = colorPicker;
    colorPicker->setVisible(true);
    colorPicker->setGeometry(cx - 28, cy, 28, 28);
    int sum = 256;
    int p1 = rand() % sum;
    int p2 = rand() % (sum - p1 - 1) + p1 + 1;
    colorPicker->setColor(qRgb(p1 + 1, p2 - p1, sum - p2 - 1));
    connect(colorPicker, SIGNAL(colorChanged()), this, SLOT(buildClick()));

    QToolButton * buildButton = new QToolButton(newTab);
    tabs[num_tabs].buildButton = buildButton;
    buildButton->setVisible(true);
    buildButton->setGeometry(cx, cy, 28, 28);
    cx += buildButton->width();
    buildButton->setAutoRaise(true);
    buildButton->setCheckable(false);
    QIcon IconNew = QIcon("icons\\play.jpg");
    buildButton->setIcon(IconNew);
    buildButton->setIconSize(QSize(24, 24));
    connect(buildButton, SIGNAL(clicked()), this, SLOT(buildClick()));

    QToolButton * visButton = new QToolButton(newTab);
    tabs[num_tabs].visButton = visButton;
    visButton->setVisible(true);
    visButton->setGeometry(cx, cy, 28, 28);
    cx += visButton->width();
    visButton->setAutoRaise(true);
    visButton->setCheckable(true);
    visButton->setChecked(false);
    IconNew = QIcon("icons\\eye1.jpg");
    visButton->setIcon(IconNew);
    visButton->setIconSize(QSize(24, 24));


    //QPalette palette(tabWidget->tabBar()->palette());
    //QBrush brush(QColor(255, 0, 0));
    //palette.setBrush(QPalette::Window, brush);
    //tabWidget->tabBar()->setTabTextColor(num_tabs, QColor(255, 0, 0));

     //= *(tabWidget->tabBar()->tabButton(num_tabs, QTabBar::LeftSide));
    //tabWidget->tabBar()->tabButton(num_tabs, QTabBar::LeftSide)->setFixedWidth(100);

    //tabWidget->tabBar()->setTabButton(num_tabs, QTabBar::LeftSide, &tabButton);//tabWidget->tabBar()->tabButton(num_tabs, QTabBar::LeftSide));

    //colorPicker->setFixedWidth(30);
    num_tabs++;

}

void MainWindow::buildClick()
{
    refreshGraph();
}

void MainWindow::deleteTab(int index)
{
    tabWidget->removeTab(index);
    //delete tabs[index].t;
    //delete tabs[index].e;
    num_tabs--;
    for (int i = index; i < num_tabs; ++i)
        tabs[i] = tabs[i + 1];
    QRect w = plusTab->geometry();
    plusTab->setGeometry(w.x() - 93, w.y(), w.width(), w.height());
    if (num_tabs == 0) addNewTab();
}

MainWindow::~MainWindow()
{
    delete ui;
}

int mouseLastX, mouseLastY;

void View::mousePressEvent(QMouseEvent * event)
{
    mouseLastX = event->x();
    mouseLastY = event->y();
    this->setCursor(Qt::ClosedHandCursor);
}
void View::mouseReleaseEvent(QMouseEvent * event)
{
    this->setCursor(Qt::OpenHandCursor);
}

void View::mouseMoveEvent(QMouseEvent * event)
{
    autoAdjustBoxes = true;
    xcBox->setValue(xcBox->value() - (event->x() - mouseLastX) * (xsBox->value() / curImage.width()));
    ycBox->setValue(ycBox->value() + (event->y() - mouseLastY) * (ysBox->value() / curImage.height()));
    autoAdjustBoxes = false;
    mouseLastX = event->x();
    mouseLastY = event->y();
    refreshGraph();
}

void View::wheelEvent( QWheelEvent * event)
{
    autoAdjustBoxes = true;
    LD X0, Y0;
    LD XS, YS;
    XS = xsBox->value();
    YS = ysBox->value();
    X0 = xcBox->value() - XS / 2;
    Y0 = ycBox->value() - YS / 2;
    LD X1, Y1;
    X1 = X0 + (XS / curImage.width()) * (event->x() + 0.5);
    Y1 = Y0 + (YS / curImage.height()) * (curImage.height() - event->y() - 0.5);
    QVector2D v(xcBox->value() - X1, ycBox->value() - Y1);
    int steps = event->delta() / 120;
    if (steps > 0)
    {
        FOR(i, steps)
        {
            v /= wheelZoomCoef;
            XS /= wheelZoomCoef;
            YS /= wheelZoomCoef;
        }
    }
    else
    {
        steps = -steps;
        FOR(i, steps)
        {
            v *= wheelZoomCoef;
            XS *= wheelZoomCoef;
            YS *= wheelZoomCoef;
        }
    }
    X0 = X1 + v.x();
    Y0 = Y1 + v.y();
    xcBox->setValue(X0);
    ycBox->setValue(Y0);
    xsBox->setValue(XS);
    if (!sizeChained) ysBox->setValue(YS);
    refreshGraph();
    autoAdjustBoxes = false;
}

void SpeedSlider::mouseReleaseEvent ( QMouseEvent * event )
{
    refreshGraph();
}

void TabTextEdit::keyPressEvent ( QKeyEvent * e )
{
    if (e->key() == Qt::Key_Return) refreshGraph();
        else QPlainTextEdit::keyPressEvent(e);
}

