#include "PL.h"
#include <cmath>
#include <cstring>
#include <cstdio>
#include <cstdlib>
#define FOR(a, b) for(int a = 0; a < (b); a++)
#define indigits(a) (digits.find(a) != digits.end())
#define inletters(a) (letters.find(a) != letters.end())
#define inoperands(a) (operands.find(a) != operands.end())


using namespace std;

const double eps = 0.000000001;
const double INF = 1000000000.0;
struct recT{
        string a;
        recT *next;
};
recT *head1, *head2;
double Left[1000];
int head;
set <char>digits;
set <char>letters;
set <char>operands;
map <char, int> priority;
bool wasKilled = false;


void push(string a, recT** head)
{
        recT *w = new recT;
        w->a = a;
        w->next = *head;
        *head = w;

}

void push1(string a)
{
    switch (a[0]) {
    case ('+'):
                if (head <= 1)
                        {wasKilled = true;return;}
        Left[--head - 1] = Left[head - 1] + Left[head];
        break;
    case ('-'):
                if (head <= 1)
                        {wasKilled = true;return;}
        Left[--head - 1] = Left[head - 1] - Left[head];
        break;
    case ('*'):
                if (head <= 1)
                        {wasKilled = true;return;}
        Left[--head - 1] = Left[head - 1] * Left[head];
        break;
    case ('/'):
                if (head <= 1)
                        {wasKilled = true;return;}
        if (abs(Left[head - 1]) < eps) {wasKilled = true;return;}
        Left[--head - 1] = Left[head - 1] / Left[head];
        break;
        case ('S'):
                if (head <= 0)
                        {wasKilled = true;return;}
                if (Left[head - 1] < 0) {wasKilled = true;return;}
        Left[head - 1] = sqrt(Left[head - 1]);
        break;
        case ('s'):
                if (head <= 0)
                        {wasKilled = true;return;}
        Left[head - 1] = sin(Left[head - 1]);
        break;
        case ('c'):
                if (head <= 0)
                        {wasKilled = true;return;}
        Left[head - 1] = cos(Left[head - 1]);
        break;
        case ('t'):
                if (head <= 0)
                        {wasKilled = true;return;}
        Left[head - 1] = tan(Left[head - 1]);
        break;
        case ('l'):
                if (head <= 0)
                        {wasKilled = true;return;}
                if (Left[head - 1] < 0) {wasKilled = true;return;}
        Left[head - 1] = log(Left[head - 1]);
        break;
        case ('^'):
                if (head <= 1)
                        {wasKilled = true;return;}
                if ((Left[head - 1] < 0)||(Left[head - 2] < 0))
                        {wasKilled = true;return;}
        Left[--head - 1] = pow(Left[head - 1], Left[head]);
        break;

    case ('('):
        {wasKilled = true;return;}
        break;
    }

}


string pop(recT** head)
{
        string p = (*head)->a;
        recT *next = (*head)->next;
        delete *head;
        *head = next;
        return p;
}

void add(string s)
{
        if (s[0] == ')')
        {
                string a;
                while ((head2 != NULL)&&(head2->a[0] != '('))
                        {push1(pop(&head2));if (wasKilled) return;}
        if (head2 == NULL) {wasKilled = true;return;}
                a = pop(&head2);
                if (a.length() != 1)
                {
                        a.erase(0, 1);
                        push1(a);
                }
                return;
        }

        if (s[0] == '(')
        {
                push(s, &head2);
                return;
        }

        while ((head2 != NULL)&&(priority.find(head2->a[0])->second >= priority.find(s[0])->second))
                {push1(pop(&head2));if (wasKilled) return;}
        push(s, &head2);
}

int n;

double countExpression(string S, double x)
{
        wasKilled = false;
        for (char i = '0'; i <= '9'; i++)
                digits.insert(i);
        for (char i = 'a'; i <= 'z'; i++)
                letters.insert(i);
        operands.insert('+');
        operands.insert('-');
        operands.insert('*');
        operands.insert('/');
        operands.insert('^');

        priority['+'] = 1;
        priority['-'] = 1;
        priority['*'] = 2;
        priority['/'] = 2;
        priority['('] = 0;
        priority['^'] = 3;

        string s;
        string st;
        string ws;
        FOR(i, st.length())
        {
            if (st[i] != ' ') ws += st[i];
        }
        st = ws;
        int i = 0;
        head = 0;
        while (i < st.length())
        {
            if (wasKilled)
                return 2 * INF;
            s = "";
            s += st[i];
            if (((st[i] == '-') || (st[i] == '+'))&&((i == 0)||(st[i - 1] == '(')))
            {
                Left[head++] = 0;
                i++;
                add(s);
                continue;
            }
            if (st[i] == 'x')
            {
                Left[head++] = x;
                ++i;
                continue;
            }

            if (digits.find(st[i]) != digits.end())
            {
                if (i != 0 && (st[i - 1] == ')')) {wasKilled = true; return 2 * INF;}
                while ((i + 1 < st.length())&&(digits.find(st[i + 1]) != digits.end()))
                    s += st[++i];
                Left[head++] = strtof(s.c_str(), NULL);
                ++i;
                continue;
            }
            if (letters.find(st[i]) != letters.end())
            {
                if (i != 0 && (indigits(st[i - 1]) || st[i - 1] == ')')) {wasKilled = true; return 2 * INF;}
                while ((i + 1 < st.length())&&(letters.find(st[i + 1]) != letters.end()))
                    s += st[++i];
                if (st[i + 1] != '(') {wasKilled = true; return 2 * INF;}
                    ++i;
                if (s == "sqrt") s[0] = 'S';
                s = '(' + s;
                i++;
                add(s);
                continue;
            }
            if (st[i] == '(' && (i != 0 && (indigits(st[i - 1]) || st[i - 1] == ')'))) {wasKilled = true; return 2 * INF;}
            if (st[i] == ')' && (i == 0 || inoperands(st[i - 1]))) {wasKilled = true; return 2 * INF;}
            if (inoperands(st[i]) && (i == 0 || inoperands(st[i - 1])||(st[i - 1] == '(')))
            {
                {wasKilled = true; return 2 * INF;}
            }
            i++;
            add(s);
        }
        if (wasKilled)
            return 2 * INF;
        if (inoperands(st[st.length() - 1])) {wasKilled = true; return 2 * INF;}
        while (head2 != NULL)
                push1(pop(&head2));

        if(head != 1) {wasKilled = true; return 2 * INF;}
        return Left[0];
}
